<?php
    /**
    *
    * copyright (c) 2013-2020 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    * 
    * classe per stampare i contenuti di Geecom Admin
    */
    class StampaContenuti {
        
        static function stampaRispostaTicket($risposta) {
            $data = date("d/m/Y",strtotime($risposta["dataCreazione"]));
            $ora  = date("H:i",strtotime($risposta["dataCreazione"]));
            $classeAggiuntiva = ($risposta["autore"]=="Amministrazione") ? "float-right" : "";
            
            echo"<div class=\"card p-4 ticket col-10 col-md-9 $classeAggiuntiva\">
                <div class=\"d-flex justify-content-between\">
                    <small class=\"text-muted mb-3\">
                        <span class=\"text-dark\">Risposta del <strong>$data</strong> <i class=\"far fa-clock\"></i> <strong>$ora</strong></span>
                    </small>
                </div>
                {$risposta["testo"]}
            </div>";
        }
        
        static function fiammePriorita($priorita) {
            if($priorita=="alta") {
                return "<i class=\"fas fa-burn mr-1\"></i><i class=\"fas fa-burn mr-1\"></i><i class=\"fas fa-burn\"></i>";
            }
            else if($priorita=="media") {
                return "<i class=\"fas fa-burn mr-1\"></i><i class=\"fas fa-burn\"></i>";
            }
            else {
                return "<i class=\"fas fa-burn mr-1\"></i>";
            }
        }
    }
